﻿using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AZVIC.Ei8htPOS.POSRetail.Helpers
{
    public static class PoleDisplayHelper
    {
        public const int ESC = 27;
        public const int Q = 81;
        public const int A = 65;
        public const int B = 66;
        public const int CR = 13;
        public const int CLR = 12;
        public const int MOVERT = 91;
        public const int C = 67;
        public const int L = 108;


        public static void DisplayOrderDetails(OrdersDetails _OrderDetail)
        {
            if (_OrderDetail != null)
            {
                string FirstLine = RemoveSpecialCharacters(_OrderDetail.ProductName);
                string SecondLine = RemoveSpecialCharacters(string.Format("{0}x{1:C}", _OrderDetail.Quantity, _OrderDetail.UnitPrice));
                string TotalPrice = string.Format("{0:C}", _OrderDetail.Amount);
                DisplayItem(FirstLine, SecondLine,TotalPrice);

            }
        }

        public static void DisplayItem(string FirstRow, string SecondRowLeft, string SecondRowRight)
        {
            try
            {
                SerialPort sp = new SerialPort();
                byte[] UpperLineDisplay = new byte[FirstRow.Length + 4];
                UpperLineDisplay[0] = ESC;
                UpperLineDisplay[1] = Q;
                UpperLineDisplay[2] = A;
                for (int i = 3; i < FirstRow.Length + 3; i++)
                {
                    UpperLineDisplay[i] = Convert.ToByte(FirstRow[i - 3]);
                }
                UpperLineDisplay[UpperLineDisplay.Length - 1] = CR;


                byte[] LowerLineDisplay = new byte[SecondRowLeft.Length + 4];
                LowerLineDisplay[0] = ESC;
                LowerLineDisplay[1] = Q;
                LowerLineDisplay[2] = B;
                for (int i = 3; i < SecondRowLeft.Length + 3; i++)
                {
                    LowerLineDisplay[i] = Convert.ToByte(SecondRowLeft[i - 3]);
                }
                LowerLineDisplay[LowerLineDisplay.Length - 1] = CR;


                int MovePosition = 20 - SecondRowLeft.Length - SecondRowRight.Length;
                byte[] LowerAmountDisplay = new byte[SecondRowRight.Length + 5];
                LowerAmountDisplay[0] = ESC;
                LowerAmountDisplay[1] = L;
                LowerAmountDisplay[2] = (byte)(MovePosition + SecondRowLeft.Length);
                LowerAmountDisplay[3] = 2;
                for (int i = 4; i < SecondRowRight.Length + 4; i++)
                {
                    LowerAmountDisplay[i] = Convert.ToByte(SecondRowRight[i - 4]);
                }
                LowerAmountDisplay[LowerAmountDisplay.Length - 1] = CR;


                byte[] LineBreak = new byte[4] {ESC,L,1,2};
                byte[] GotoHome = new byte[4] { ESC,L,1,1 };
                //ESC [ B
                sp.PortName = "COM2";
                sp.BaudRate = 9600;
                sp.Parity = Parity.None;
                sp.DataBits = 8;
                sp.StopBits = StopBits.One;
                sp.Open();

                sp.Write(GotoHome, 0, GotoHome.Length);
                sp.Write(UpperLineDisplay, 0, UpperLineDisplay.Length);
                if(SecondRowLeft.Length > 0 || SecondRowRight.Length >0)
                sp.Write(LineBreak, 0, LineBreak.Length);
                if (SecondRowLeft.Length > 0)
                sp.Write(LowerLineDisplay, 0, LowerLineDisplay.Length);
                if (SecondRowRight.Length > 0)
                sp.Write(LowerAmountDisplay, 0, LowerAmountDisplay.Length);


                sp.Close();
                sp.Dispose();
                sp = null;
            }
            catch
            {

            }
        }

        public static void DisplayWelcomeMessage()
        {
            DisplayItem(AppSession.PoleDisplayWelcomeText, string.Empty, string.Empty);
        }

        public static void ClearDisplay()
        {
            try
            {
                SerialPort sp = new SerialPort();
                sp.PortName = AppSession.PoleDisplayPort;
                sp.BaudRate = 9600;
                sp.Parity = Parity.None;
                sp.DataBits = 8;
                sp.StopBits = StopBits.One;
                sp.Open();

                byte[] ClearBytes = new byte[] { 27,64 };
                sp.Write(ClearBytes, 0, ClearBytes.Length);

                sp.Close();
                sp.Dispose();
                sp = null;
            }
            catch
            {

            }
        }

        public static string RemoveSpecialCharacters(string str)
        {
            StringBuilder sb = new StringBuilder();
            foreach (char c in str)
            {
                if ((c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || c == '.' || c == '_' || c== '$')
                {
                    sb.Append(c);
                }
            }
            return sb.ToString();
        }

    }
}
